<?php defined('BASEPATH') OR exit('No direct script access allowed');
class User extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		$this->load->model('adminmodel');
		$this->load->model('mastermodel');
		$this->load->model('usermodel');
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$type = $this->uri->segment(3);
		$get_url_id = $this->adminmodel->user_form_authentication($url,$type);
	}	

	/************************************* START user ************************************/
	
	public function listuser($type) //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		
	$data = array();
			
		$tableName = "admin";
		$orderBy = "admin_id";
		$data['title'] = "List user";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['user_name']=$this->usermodel->view_user_data($tableName,$orderBy);
		$data['state_name']=$this->mastermodel->view_all_data('state','state'); 
		$data['city_name']=$this->mastermodel->view_all_data('city','city');
		
       	$this->load->view('user/listuser', $data);
	}	

    public function adduser($type,$id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "admin";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['state_name']=$this->mastermodel->view_all_data('state','state');
		$data['city_name']=$this->mastermodel->view_all_data('city','city');
			if(!empty($id))
			{
				$data['title'] = "Edit User";
				$condition = array('admin_id'=>$id);
				$data['user_name_data'] = $this->usermodel->edit_current_data($tableName,$condition);
				//print_r($data['user_name']);
				$this->load->view('user/adduser',$data);
			}
			else
			{
				$data['title'] = "Add User";
				$this->load->view('user/adduser', $data);
			}
    }
	
	public function insert_user($id=NULL) // Insert data Into Database
	{	
	
			$admin_id=$this->session->userdata['admin_id'];
			$current_datetime= date('Y-m-d H:i:s');
			$admin_ip=$_SERVER['REMOTE_ADDR'];
	
			$tableName = "admin";
			$name=$this->input->post('name');
			$address=$this->input->post('address');
			$state=$this->input->post('state');
			$city=$this->input->post('city');
			$pin=$this->input->post('pin');
			$uid=$this->input->post('uid');
			$email=$this->input->post('email');
			$password=$this->input->post('password');
			if(!empty($id))
			{
				$update_data = array(
				'name' => $name,
				'address' => $address,
				'state' => $state,
				'city' => $city,
				'pincode' => $pin,
				'uid' => $uid,
				'email' => $email,
				'pwd' => $password
				);
				$condition = array('admin_id'=>$id);
				$data_exist = $this->usermodel->update_current_data($tableName,$condition,$update_data);
				redirect('user/submitted/2');
			}
			else
			{
				$insert_data = array(
				'name' => $name,
				'address' => $address,
				'state' => $state,
				'city' => $city,
				'pincode' => $pin,
				'uid' => $uid,
				'email' => $email,
				'pwd' => $password
				);
				$data_exist = $this->usermodel->add_current_data($tableName,$insert_data);
			}
			if($data_exist)
			{
			  $this->session->set_flashdata('duplicate_message',$country.' Already Exist');
				redirect('user/adduser/'.$id);
			}
			else
			{
				redirect('user/submitted/1');
			}
		}
	public function delete_user($id)  // Delete From Database
	{
		$tableName = "admin";
		$condition = array('admin_id'=>$id);
		$this->usermodel->delete_current_data($tableName,$condition);
		redirect('user/listuser/4');
	}
	/*********************  END user  *****************************************/
	
		public function submitted($id)
	{	
		if($id ==1)
		{
			$data['submit_msg'] = "User Inserted Successfully";
		}elseif($id ==2)
		{
			$data['submit_msg'] = "User Updated Successfully";
		}
		
		
		$data['title'] = "Form Submitted";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$this->load->view('form_submit',$data);
	}
	
		
}  //Close user Class 
?>
