<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Product extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		$this->load->library('excel');
		$this->load->model('adminmodel');
		$this->load->model('mastermodel');
		$this->load->model('productmodel');
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$type = $this->uri->segment(3);
		$get_url_id = $this->adminmodel->user_form_authentication($url,$type);
	}	

	/************************************* START product ************************************/
	
	public function listproduct() //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		$tableName = "product";
		$orderBy = "product";
		$data['title'] = "List product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['product_name']=$this->productmodel->view_all_data($tableName,$orderBy); 
		$data['unit_name']=$this->mastermodel->view_all_data('unit','unit');
		$data['numberpart_name']=$this->mastermodel->view_all_data('numberpart','numberpart');
		$data['category_name']=$this->mastermodel->view_all_data('category','name'); 

       	$this->load->view('product/listproduct', $data);
	}	

    public function addproduct($type,$id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['unit_name']=$this->mastermodel->view_all_data('unit','unit');
		$data['numberpart_name']=$this->mastermodel->view_all_data('numberpart','numberpart');
		$data['category_name']=$this->mastermodel->view_all_data('category','name'); 
			if(!empty($id))
			{
				$data['title'] = "Edit product";
				$condition = array('id'=>$id);
				$data['product_name'] = $this->productmodel->edit_current_data($tableName,$condition);
				$this->load->view('product/addproduct', $data);
			}
			else
			{
				$data['title'] = "Add product";
				$this->load->view('product/addproduct', $data);
			}
    }
	
	public function insert_product($id=NULL) // Insert data Into Database
	{	
	
		if(isset($_FILES['userfile']['name']))
		{
				$config['upload_path']          = '.././product_image/';
                $config['allowed_types']        = 'pdf|PDF|doc|docx|jpg|JPG|jpeg|png|JPEG';
				$config['remove_spaces'] = TRUE;
				$new_name =$_FILES["userfile"]['name'];
				$config['file_name'] = $new_name;
				
                $this->load->library('upload', $config);
                if(!$this->upload->do_upload('userfile'))
                {
                        $error = array('error' => $this->upload->display_errors());
						$file_name = "";
                       //$this->load->view('employment/addemployment', $error);
					 //  print_r($error);
                }
                else
                {
                        $data = $this->upload->data();
						$file_name = "product_image/".$data['file_name'];
                        //$this->load->view('upload_success', $data);
                }
				//echo $file_name;
				
				
		}	
	
			$admin_id=$this->session->userdata['admin_id'];
			$current_datetime= date('Y-m-d H:i:s');
			$admin_ip=$_SERVER['REMOTE_ADDR'];
	
			$tableName = "product";
			$category_id=$this->input->post('category_id');
			$product=$this->input->post('name');
			$item_code=$this->input->post('item_code');
			$entry_code=$this->input->post('entry_code');
			$numberpart=$this->input->post('numberpart_id');
			$unit_id=$this->input->post('unit_id');
			$specification=$this->input->post('specification');
			$specification1=addslashes($specification);
			$installation=$this->input->post('installation');
			//exit();
			if(!empty($id))
			{
				if($file_name!='')
					{
					$update_data = array(
					'category_id'=> $category_id,
					'product' => $product,
					'item_code' => $item_code,
					'entry_code' => $entry_code,
					'numberpart_id' => $numberpart,
					'unit_id' => $unit_id,
					'specification' => $specification1,
					'installation' =>$installation,
					'image' => $file_name,
					'modified_by' => $admin_id,
					'modified_ip'  => $admin_ip,
					'modified_date'  => $current_datetime
					);
					}
				else
					{
					$update_data = array(
					'category_id'=> $category_id,
					'product' => $product,
					'item_code' => $item_code,
					'entry_code' => $entry_code,
					'numberpart_id' => $numberpart,
					'unit_id' => $unit_id,
					'specification' => $specification1,
					'installation' =>$installation,
					'modified_by' => $admin_id,
					'modified_ip'  => $admin_ip,
					'modified_date'  => $current_datetime
					);
					}
				$condition = array('id'=>$id);
				$data_exist = $this->productmodel->update_current_data($tableName,$condition,$update_data);
				redirect('product/submitted/2');
			}
			else
			{
				$insert_data = array(
				'category_id'=> $category_id,
				'product' => $product,
				'item_code' => $item_code,
				'entry_code' => $entry_code,
				'numberpart_id' => $numberpart,
				'unit_id' => $unit_id,
				'specification' => $specification1,
				'installation' =>$installation,
				'image' => $file_name,
				'created_by' => $admin_id,
				'created_ip'  => $admin_ip,
				'created_date'  => $current_datetime
				);
				$data_exist = $this->productmodel->add_current_data($tableName,$insert_data);
			}
			if($data_exist)
			{
			  $this->session->set_flashdata('duplicate_message',$country.' Already Exist');
				redirect('product/addproduct/'.$id);
			}
			else
			{
				redirect('product/submitted/1');
			}
		}
	public function delete_product($id)  // Delete From Database
	{
		$tableName = "product";
		$condition = array('id'=>$id);
		$this->productmodel->delete_current_data($tableName,$condition);
		redirect('product/listproduct/4');
	}
	/*********************  END product  *****************************************/
	
		public function importexcelproduct()  // Delete From Database
	{
		$data['title'] = "List Product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		//$data["package"] = $this->employeemodel->package();
		
		//print_r($data["package"]);
		//exit();
		$this->load->view('product/importexcelproduct',$data);
	}
	
	public function importdata()
	{
		$admin_id=$this->session->userdata['admin_id'];
		$current_datetime= date('Y-m-d H:i:s');
		$admin_ip=$_SERVER['REMOTE_ADDR'];
		//$package_id = $this->input->post('package_id');
		
		  if(isset($_FILES["file"]["name"]))
		  {
		   $path = $_FILES["file"]["tmp_name"];
		   $object = PHPExcel_IOFactory::load($path);
		   foreach($object->getWorksheetIterator() as $worksheet)
		   {
			$highestRow = $worksheet->getHighestRow();
			$highestColumn = $worksheet->getHighestColumn();
			for($row=2; $row<=$highestRow; $row++)
			{
			 
/*		$first_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
		$middle_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
		$last_name = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
		$mobile = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
		$package_id = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
		$email = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
		$active = '5';
*/
		$category_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
		$product_name = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
		$item_code = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
		$order_entry_code = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
		$numberpart_name = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
		$unit_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
		$installation = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
		
		$product_check = $this->db->get_where('product',array('item_code'=>$item_code));
		if($product_check->num_rows() <= 0)
			{
			
			$category = $this->db->get_where('category',array('name'=>$category_name))->result();
			foreach($category as $category_data)
			{
			$cat_id = $category_data->id;
			}
			
			if(!empty($cat_id))
			{
			$category_id = $cat_id;
			}
			else
			{
			$this->db->insert('category',array('name'=>$category_name));
			$category_id = $this->db->insert_id();
			}
		//exit();
			$numberpart = $this->db->get_where('numberpart',array('numberpart'=>$numberpart_name))->result();
			foreach($numberpart as $numberpart_data)
			{
				$num_id = $numberpart_data->id;
			}
			
			if(!empty($num_id))
			{
			$numberpart_id = $num_id;
			}
			else
			{
			$this->db->insert('numberpart',array('numberpart'=>$numberpart_name));
			$numberpart_id = $this->db->insert_id();
			}
						
			$unitq = $this->db->get_where('unit',array('unit'=>$unit_name))->result();
			foreach($unitq as $unit_data)
			{
				$uni_id = $unit_data->id;
			}
			
			if(!empty($uni_id))
			{
			$unit_id = $uni_id;
			}
			else
			{
			$this->db->insert('unit',array('unit'=>$unit_name));
			$unit_id = $this->db->insert_id();
			}
			//$category_id=1;
			//$numberpart_id=1;
			//$unit_id=1;
			//item_code
			
				$product_data = array(
				'category_id' => $category_id,
				'product' => $product_name,
				//'package_id' => $package_id,
				'item_code' => $item_code,
				'entry_code' => $order_entry_code,
				'numberpart_id' => $numberpart_id,
				'unit_id' => $unit_id,
				'installation' => $installation,
				'created_by' => $admin_id,
				'created_ip' => $admin_ip,
				'created_date' => $current_datetime
				);
				$data_exist = $this->productmodel->importexcelproductm($product_data);
			}
		   }	
		   }
		   //$this->excel_import_model->insert($data);
		   //print_r($data);
			redirect('product/listproduct');
		  } 
	}
	
	
		public function submitted($id)
	{	
		if($id ==1)
		{
			$data['submit_msg'] = "Your Product Inserted Successfully";
		}elseif($id ==2)
		{
			$data['submit_msg'] = "Your Product Updated Successfully";
		}
		
		
		$data['title'] = "Form Submitted";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$this->load->view('form_submit',$data);
	}
			
}  //Close product Class 
?>
