<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Product extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		$this->load->model('adminmodel');
		$this->load->model('productmodel');
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$type = $this->uri->segment(3);
		$get_url_id = $this->adminmodel->user_form_authentication($url,$type);
	}	

	
	
	/************************************* START user ********************************/
	
	public function listproduct($type) //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		$tableName = "product";
		$orderBy = "product_name";
		$data['title'] = "List product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['packing_name']=$this->productmodel->view_all_data('packing','packing');
		$data['category_name']=$this->productmodel->view_all_data('category','category_name');
		//$data['product_child_data']=$this->productmodel->view_all_data('product_child','product_id');
		$data['packing_unit_name']=$this->productmodel->view_packing_unit_data();
		
		$conditioncurrency = array('active'=>1); 
		$data['currency_name']=$this->productmodel->view_currency_data('currency',$conditioncurrency);

		
		$limit_per_page = 15;
        $page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
       	//$total_records = 50;
       	//$total_records = $this->productmodel->get_total_count($tableName);
		
		$total_records = $this->productmodel->view_all_product_data($tableName,$orderBy);
		//print_r($this->db->last_query());
		//exit();
		if($total_records)
		{
		$total_records = count($total_records);
		}else
		{
		$total_records = "0";
		}		
		
		//exit();
     	$data['limit_per_page'] =  $limit_per_page;
		$data['page'] =  $page;
		$data['total_records'] =  $total_records;
        if ($total_records > 0)
        {
            // get current page records
            $data['product_name']=$this->productmodel->view_all_product_data($tableName,$orderBy,$limit_per_page,$page*$limit_per_page);
			$data['product_child_data']=$this->productmodel->view_all_data('product_child','product_id');
			$config['base_url'] = base_url() . 'product/listproduct/'.$type;
			$config['total_rows'] = $total_records;
			$config['per_page'] = $limit_per_page;
			$config["uri_segment"] =4;
			// custom paging configuration
			$config['num_links'] = 2;
			$config['use_page_numbers'] = TRUE;
			$config['reuse_query_string'] = TRUE;
			$config['full_tag_open'] = '<div class="pagination">';
			$config['full_tag_close'] = '</div>';
			$config['first_link'] = 'First Page';
			$config['first_tag_open'] = '<span class="firstlink">';
			$config['first_tag_close'] = '</span>';
			$config['last_link'] = 'Last Page';
			$config['last_tag_open'] = '<span class="lastlink">';
			$config['last_tag_close'] = '</span>';
			$config['next_link'] = 'Next Page';
			$config['next_tag_open'] = '<span class="nextlink">';
			$config['next_tag_close'] = '</span>';
			$config['prev_link'] = 'Prev Page';
			$config['prev_tag_open'] = '<span class="prevlink">';
			$config['prev_tag_close'] = '</span>';
			$config['cur_tag_open'] = '<span class="curlink">';
			$config['cur_tag_close'] = '</span>';
			$config['num_tag_open'] = '<span class="numlink">';
			$config['num_tag_close'] = '</span>';
             
            $this->pagination->initialize($config);
            $data["links"] = $this->pagination->create_links();
           }
       $this->load->view('product/listproduct', $data);
	}	
	
	

    public function addproduct($type,$id=NULL) // Open Add form  and Edit 
    {	
    	
		$this-> form_authentication();
		$tableName = "product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['packing_name']=$this->productmodel->view_all_data('packing','packing');
		$data['packing_unit_name']=$this->productmodel->view_packing_unit_data();
		$conditioncurrency = array('active'=>1); 
		$data['currency_name']=$this->productmodel->view_currency_data('currency',$conditioncurrency);
		
		$data['setting_name']=$this->productmodel->view_all_data('setting','id');
		
		$condition = array('belongsto'=>'0');
		$tableName1 = "category";
		$orderBy1 = "category_name";
		$data['category_name']=$this->productmodel->view_all_data_condition($tableName1,$orderBy1,$condition);
		//$data['product_name']=$this->productmodel->view_all_data($tableName,'product_name');

		//$data['unit_name']=$this->productmodel->view_all_data('unit','unit');
		
		//print_r($data['product_number']);
		//exit();
			if(!empty($id))
			{
				$data['title'] = "Edit product";
				$condition = array('id'=>$id);
				$condition2 = array('product_image_or_not'=>0);
				$condition21 = array('product_image_or_not'=>1);
				$data['uploaded_document'] = $this->productmodel->edit_product_child_image_data('product_child_image',$condition2);
				$data['uploaded_document1'] = $this->productmodel->edit_product_child_image_data1('product_child_image',$condition21);
				//print_r($data['uploaded_document1']);
				//exit();
				$data['product_name11'] = $this->productmodel->edit_current_data($tableName,$condition); //  master Data 
				$data['product_item_name'] = $this->productmodel->edit_current_data('product_child',array('product_id'=>$id));//  Child  Data 
				//print_r($data['product_item_name']);
				//exit();	
				$this->load->view('product/addproduct', $data);
			}
			else
			{
				$data['title'] = "Add product";
				
				$this->load->view('product/addproduct', $data);
			}
    }
	
	
	public function upload_product($id=NULL) // Insert data Into Database
		{	
					/*$id = $this->input->post('id');
					$query = $this->db->get_where('product_child_image',array('id'=>$id))->result();
					foreach ($query as $key) {
					if(file_exists('../'.$key->image))
					{
					unlink('../'.$key->image);
					}
					if(file_exists('../'.$key->main_image_thumb))
					{
					unlink('../'.$key->main_image_thumb);
					}
					}
					$this->db->delete('product_child_image',array('id'=>$id));*/
		if(!empty($id))
		{      
				if(!empty($_FILES['userfile1']['name']))
				{	
					$max = "id";
					$max_id = $id;
					$config['upload_path']          = '../product_image/';
				    $config['allowed_types']        = 'png|jpg|';
					$config['remove_spaces'] = TRUE;
					$config['overwrite']     = TRUE;
					$new_name = $max_id.'_'.$_FILES["userfile1"]['name'];
					$config['file_name'] = $new_name;
				    $this->load->library('upload', $config);
				    $this->upload->do_upload('userfile1');
				    $data = $this->upload->data();
					$filename = "product_image/".$new_name;
					
					$file_ext = $data['file_ext'];
					$orig_name = $data['orig_name'];
					$orig_name_new = substr_replace($orig_name ,"", -4);
					$filename_thumb = "product_image/thumb/".$orig_name_new."_thumb".$file_ext;
					$this->resizeImage($data['file_path'],$data['file_name']);
					
					
					$data = array(
					'product_id' => $max_id,
					'main_image_thumb' => $filename_thumb,
					'image' => $filename,
					'product_image_or_not' =>1
					);
					$this->db->insert('product_child_image',$data);
					
				}
				
			///////////////////////////// Multiple Image ///////////////////////////	
			
						$dataInfo = array();
						$files = $_FILES;
				
						$check_array = $_FILES['userfile']['name'];
						if (isset($check_array)) {
						$cpt = sizeof($_FILES['userfile']['name']);
						for($i=0; $i<$cpt; $i++)
						{           
						$_FILES['userfile']['name']= $id.'_'.$files['userfile']['name'][$i];
						$_FILES['userfile']['type']= $files['userfile']['type'][$i];
						$_FILES['userfile']['tmp_name']= $files['userfile']['tmp_name'][$i];
						$_FILES['userfile']['error']= $files['userfile']['error'][$i];
						$_FILES['userfile']['size']= $files['userfile']['size'][$i];    
						$this->load->library('upload', $config);
						$this->upload->initialize($this->set_upload_options('product_image'));
						$this->upload->do_upload('userfile');
						
						
						$dataInfo[] = $this->upload->data();
						$document = $dataInfo[$i]['file_name'];
						
							if($document !="" )
							{
							
								$data = array(
								'product_id' => $id,
								'image' => 'product_image/'.$document,
								'product_image_or_not' =>0
								);
								$this->db->insert('product_child_image',$data);
							
							}
						}
					}
			///////////////////////////// Multiple Image ///////////////////////////	
		
		}	
		else
		 {
				if(!empty($_FILES['userfile1']['name']))
				{	
					$max = "id";
					$max_id = $this->productmodel->get_max_id('product',$max);
					$config['upload_path']          = '../product_image/';
				    $config['allowed_types']        = 'png|jpg|';
					$config['remove_spaces'] = TRUE;
					$config['overwrite']     = TRUE;
					$new_name = $max_id.'_'.$_FILES["userfile1"]['name'];
					$config['file_name'] = $new_name;
				    $this->load->library('upload', $config);
				    $this->upload->do_upload('userfile1');
				    $data = $this->upload->data();
					$filename = "product_image/".$new_name;
					
					$file_ext = $data['file_ext'];
					$orig_name = $data['orig_name'];
					$orig_name_new = substr_replace($orig_name ,"", -4);
					$filename_thumb = "product_image/thumb/".$orig_name_new."_thumb".$file_ext;
					$this->resizeImage($data['file_path'],$data['file_name']);
					
					
					$data = array(
					'product_id' => $max_id,
					'main_image_thumb' => $filename_thumb,
					'image' => $filename,
					'product_image_or_not' =>1
					);
					$this->db->insert('product_child_image',$data);
					
				}
				
			///////////////////////////// Multiple Image ///////////////////////////	
			
						$dataInfo = array();
						$files = $_FILES;
				
						$check_array = $_FILES['userfile']['name'];
						if (isset($check_array)) {
						$cpt = sizeof($_FILES['userfile']['name']);
						for($i=0; $i<$cpt; $i++)
						{           
						$_FILES['userfile']['name']= $max_id.'_'.$files['userfile']['name'][$i];
						$_FILES['userfile']['type']= $files['userfile']['type'][$i];
						$_FILES['userfile']['tmp_name']= $files['userfile']['tmp_name'][$i];
						$_FILES['userfile']['error']= $files['userfile']['error'][$i];
						$_FILES['userfile']['size']= $files['userfile']['size'][$i];    
						$this->load->library('upload', $config);
						$this->upload->initialize($this->set_upload_options('product_image'));
						$this->upload->do_upload('userfile');
						
						
						$dataInfo[] = $this->upload->data();
						$document = $dataInfo[$i]['file_name'];
						
							if($document !="" )
							{
							
								$data = array(
								'product_id' => $max_id,
								'image' => 'product_image/'.$document,
								'product_image_or_not' =>0
								);
								$this->db->insert('product_child_image',$data);
							
							}
						}
					}
			///////////////////////////// Multiple Image ///////////////////////////	
				
				}
								
					if(!empty($id))
					{
					redirect('product/submitted/2');
					}
					else
					{
					redirect('product/submitted/1');
					}
		}
	
	public function insert_product($id=NULL) // Insert data Into Database
	{	

		$tableName = "product";
		$MasterItemData = json_decode($this->input->post('MasterItemData'));
		$ChildItemData = json_decode($this->input->post('ChildItemData'));
		$CheckboxItemData = json_decode($this->input->post('CheckboxItemData'));
		//$CheckboxItemData = json_decode('[{"sub_category_id":"6"},{"sub_category_id":"7"}]');
		//$product_number= $this->productmodel->get_max_id('product','product_number');
		$admin_id=$this->session->userdata['admin_id'];
		$current_datetime= date('Y-m-d H:i:s');
		$admin_ip=$_SERVER['REMOTE_ADDR'];

		if(!empty($id))
		{      
			if(!empty($MasterItemData))
			{
			foreach($MasterItemData as $Master) 
				{
					$update_data = array(
					'product_name' => $Master->product_name,
					'item_code' => $Master->item_code,
					'category_id' => $Master->category_id,
					'sort_order' => $Master->sort_order,
					'featured' => $Master->featured,
					'in_stock' => $Master->in_stock,
					'active' => $Master->active,
					'modified_by' => $admin_id,
					'modified_date' => $current_datetime,
					'modified_ip' => $admin_ip
					);
					//print_r($insert_data);
					$condition = array('id'=>$id);
					$this->productmodel->update_current_data($tableName,$condition,$update_data);
					
				}
			}
			$this->productmodel->delete_current_data('product_child',array('product_id'=>$id));
			if(!empty($ChildItemData))
			{
			
			foreach($ChildItemData as $ChildItem) 
				{
					$insert_data_product_child = array(
					'product_id' => $id,
					'packing_id' => $ChildItem->packing_id,
					'rate' => $ChildItem->rate,
					'discount' => $ChildItem->discount,
					'price' => $ChildItem->price,
					'default_value' => $ChildItem->default_value,
					'maxqty' => $ChildItem->maxqty,
					'active'=>'1'
					);

					$this->productmodel->add_current_data('product_child',$insert_data_product_child);
				}
			}
			
			$this->productmodel->delete_current_data('product_category_child',array('product_id'=>$id));
			if(!empty($CheckboxItemData))
			{
			
			foreach($CheckboxItemData as $CheckboxItem) 
				{
					$insert_data_product_category_child = array(
					'product_id' => $id,
					'sub_category_id' => $CheckboxItem->sub_category_id
					);

					$this->productmodel->add_current_data('product_category_child',$insert_data_product_category_child);
				}
			}
			
				
		
		}
		else
		{
			if(!empty($MasterItemData))
			{
			foreach($MasterItemData as $Master) 
				{
					//$url_name= => $Master->product_name;
					$insert_data = array(
					'product_name' => $Master->product_name,
					'item_code' => $Master->item_code,
					'category_id' => $Master->category_id,
					'sort_order' => $Master->sort_order,
					'featured' => $Master->featured,
					'in_stock' => $Master->in_stock,
					'active' => $Master->active,
					'created_by' => $admin_id,
					'created_date' => $current_datetime,
					'created_ip' => $admin_ip,
					'modified_date' => '0000-00-00 00:00:00'
					);
					//print_r($insert_data);
					//exit();
					//[{"product_name":"rw","item_code":"test-433","category_id":"3"}]
					//[{"packing_id":"2","rate":"200"}]
					$last_inserted_id = $this->productmodel->add_current_data($tableName,$insert_data);
				}
			}
			if(!empty($ChildItemData))
			{
			foreach($ChildItemData as $ChildItem) 
				{
					$insert_data_product_child = array(
					'product_id' => $last_inserted_id,
					'packing_id' => $ChildItem->packing_id,
					'rate' => $ChildItem->rate,
					'discount' => $ChildItem->discount,
					'price' => $ChildItem->price,
					'default_value' => $ChildItem->default_value,
					'maxqty' => $ChildItem->maxqty,
					'active'=>'1'
					);

					$this->productmodel->add_current_data('product_child',$insert_data_product_child);
				}
			}
			
			if(!empty($CheckboxItemData))
			{
			foreach($CheckboxItemData as $CheckboxItem) 
				{
					$insert_data_product_category_child = array(
					'product_id' => $last_inserted_id,
					'sub_category_id' => $CheckboxItem->sub_category_id
					);

					$this->productmodel->add_current_data('product_category_child',$insert_data_product_category_child);
				}
			}
			
			return "success";
		}
	}
	/*public function add($id=NULL)
	{
	echo json_decode('[{"xyz":"6"}');
	}*/
	public function productdetail($id=NULL) // Open Add form  and Edit 
    {	
    	
		$this-> form_authentication();
		$tableName = "product";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['packing_name']=$this->productmodel->view_all_data('packing','packing');
		$data['category_name']=$this->productmodel->view_all_data('category','category_name');
		$data['item_name']=$this->productmodel->view_all_data('item','item_name'); // First Parameter In TableName 2nd Order By
		//print_r($data['item_name']);
		$data['title'] = "product Detail";
		$condition = array('id'=>$id);
		$data['product_name'] = $this->productmodel->edit_current_data($tableName,$condition); //  master Data 
		$data['product_item_name'] = $this->productmodel->edit_current_data('product_child',array('product_id'=>$id));//  Child  Data 		//print_r($data['product_number']);
		$this->load->view('product/productdetail', $data);
			
    }
	public function delete_product($id)  // Delete From Database
	{
		$tableName = "product";
		$condition = array('id'=>$id);
		
		$image_exist = $this->productmodel->image_exist('product',$condition);
		foreach ($image_exist as $key) {
		if(file_exists('../'.$key->image))
		{
		unlink('../'.$key->image);
		}
		if(file_exists('../'.$key->main_image_thumb))
		{
		unlink('../'.$key->main_image_thumb);
		}
	  }
		
		$this->productmodel->delete_current_data($tableName,$condition);
		$this->productmodel->delete_current_data('product_child',array('product_id'=>$id));
		$this->productmodel->delete_current_data('product_category_child',array('product_id'=>$id));
		$this->productmodel->delete_current_data('product_child_image',array('product_id'=>$id));
		redirect('product/listproduct/4');
	}
	public function delete_product_item($id)  // Delete From Database
	{
		$this->productmodel->delete_current_data('product_child',array('id'=>$id));
	}
	/************************************* START product ********************************/
	

	public function submitted($id)
	{	
		if($id ==1)
		{
			$data['submit_msg'] = "Your Product Inserted Successfully";
		}elseif($id ==2)
		{
			$data['submit_msg'] = "Your Product Updated Successfully";
		}
		
		
		$data['title'] = "Form Submitted";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$this->load->view('form_submit',$data);
	}
	
	public function change_status()
	{
	$id=$this->input->post('id');
	$active=$this->input->post('active');
	if($active==1)
	{
	$change_active='0';
	}
	else
	{
	$change_active='1';
	}
	$value=array('active'=>$change_active);
	$this->db->where('id',$id);
	$this->db->update('product_child',$value);
	}
	
	public function change_statusf()
	{
	$id=$this->input->post('id');
	$active=$this->input->post('active');
	if($active==1)
	{
	$change_active='0';
	}
	else
	{
	$change_active='1';
	}
	$value=array('featured'=>$change_active);
	$this->db->where('id',$id);
	$this->db->update('product',$value);
	}
	public function change_statuss()
	{
	$id=$this->input->post('id');
	$active=$this->input->post('active');
	if($active==1)
	{
	$change_active='0';
	}
	else
	{
	$change_active='1';
	}
	$value=array('in_stock'=>$change_active);
	$this->db->where('id',$id);
	$this->db->update('product',$value);
	}
	public function change_statusa()
	{
	$id=$this->input->post('id');
	$active=$this->input->post('active');
	if($active==1)
	{
	$change_active='0';
	}
	else
	{
	$change_active='1';
	}
	$value=array('active'=>$change_active);
	$this->db->where('id',$id);
	$this->db->update('product',$value);
	}
	
public function resizeImage($file_path,$file_name)
{
      $source_path =$file_path . $file_name;
      $target_path =$file_path . "thumb/" . $file_name;
      $config_manip = array(
         'image_library' => 'gd2',
          'source_image' => $source_path,
          'new_image' => $target_path,
          'maintain_ratio' => TRUE,
          'create_thumb' => TRUE,
          'thumb_marker' => '_thumb',
          'width' => 400,
          'height' => 400
      );
      $this->load->library('image_lib', $config_manip);
      if (!$this->image_lib->resize()) {
          echo $this->image_lib->display_errors();
      }
      $this->image_lib->clear();
}

	private function set_upload_options($folder)
	{   
	$config = array();
	$config['upload_path'] = '../'.$folder.'/';
	$config['allowed_types'] = 'jpg|png';
	$config['max_size']      = '0';
	$config['overwrite']     = TRUE;
	return $config;
	}
	
public function delete_product_image()
	{
		$id = $this->input->post('id');
		$query = $this->db->get_where('product_child_image',array('id'=>$id))->result();
		foreach ($query as $key) {
			//echo $key->image;
			//exit();
			if(file_exists('../'.$key->image))
			{
				unlink('../'.$key->image);
			}
			if(file_exists('../'.$key->main_image_thumb))
			{
				unlink('../'.$key->main_image_thumb);
			}
		}
		$this->db->delete('product_child_image',array('id'=>$id));
		echo $msg = "This Product Image Deleted Successfully";
	}
		
}  //Close rawmaterial Class 
?>
