<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Master extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		$this->load->model('adminmodel');
		$this->load->model('mastermodel');
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$get_url_id = $this->adminmodel->user_master_form_authentication($url);
	}	

	/************************************* START UNIT ************************************/
	
	public function listunit() //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		$tableName = "unit";
		$orderBy = "unit";
		$data['title'] = "List Unit";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['unit_name']=$this->mastermodel->view_all_data($tableName,$orderBy);   
		$data["unit_check_id"] = $this->mastermodel->get_unit_id(); 

       	$this->load->view('master/listunit', $data);
	}	

    public function addunit($id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "unit";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
			if(!empty($id))
			{
				$data['title'] = "Edit Unit";
				$condition = array('id'=>$id);
				$data['unit_name'] = $this->mastermodel->edit_current_data($tableName,$condition);
				$this->load->view('master/addunit', $data);
			}
			else
			{
				$data['title'] = "Add Unit";
				$this->load->view('master/addunit', $data);
			}
    }
	
	public function insert_unit($id=NULL) // Insert data Into Database
	{	
			$tableName = "unit";
			$unit=$this->input->post('unit');
			if(!empty($id))
			{
				$update_data = array(
				'unit' => $unit
				);
				$condition = array('id'=>$id);
				$data_exist = $this->mastermodel->update_current_data($tableName,$condition,$update_data);
			}
			else
			{
				$insert_data = array(
				'unit' => $unit
				);
				$data_exist = $this->mastermodel->add_current_data($tableName,$insert_data);
			}
			if($data_exist)
			{
			  $this->session->set_flashdata('duplicate_message',$country.' Already Exist');
				redirect('master/addcountry/'.$id);
			}
			else
			{
				redirect('master/listunit');
			}
		}
	public function delete_unit($id)  // Delete From Database
	{
		$tableName = "unit";
		$condition = array('id'=>$id);
		$this->mastermodel->delete_current_data($tableName,$condition);
		redirect('master/listunit');
	}
	/*********************  END UNIT  *****************************************/
	
	/************************************* START packing ************************************/
	
	public function listpacking() //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		$tableName = "packing";
		$orderBy = "packing";
		$data['title'] = "List Packing";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['packing_name']=$this->mastermodel->view_all_data($tableName,$orderBy); 
		$data['unit_name']=$this->mastermodel->view_all_data('unit','unit'); 
		//$data["unit_check_id"] = $this->mastermodel->get_unit_id(); 
		//$data["packing_check_id"] = $this->mastermodel->get_packing_id();  

       	$this->load->view('master/listpacking', $data);
	}	

    public function addpacking($id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "packing";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['unit_name']=$this->mastermodel->view_all_data('unit','unit'); 
			if(!empty($id))
			{
				$data['title'] = "Edit Packing";
				$condition = array('id'=>$id);
				$data['packing_name'] = $this->mastermodel->edit_current_data($tableName,$condition);
				$this->load->view('master/addpacking', $data);
			}
			else
			{
				$data['title'] = "Add Packing";
				$this->load->view('master/addpacking', $data);
			}
    }
	
	public function insert_packing($id=NULL) // Insert data Into Database
	{	
			$tableName = "packing";
			$packing=$this->input->post('packing');
			$unit_id=$this->input->post('unit_id');
			if(!empty($id))
			{
				$update_data = array(
				'packing' => $packing,
				'unit_id' => $unit_id
				);
				$condition = array('id'=>$id);
				$data_exist = $this->mastermodel->update_current_data($tableName,$condition,$update_data);
			}
			else
			{
				$insert_data = array(
				'packing' => $packing,
				'unit_id' => $unit_id
				);
				$data_exist = $this->mastermodel->add_current_data($tableName,$insert_data);
			}
			if($data_exist)
			{
			  $this->session->set_flashdata('duplicate_message',$country.' Already Exist');
				redirect('master/addcountry/'.$id);
			}
			else
			{
				redirect('master/listpacking');
			}
		}
	public function delete_packing($id)  // Delete From Database
	{
		$tableName = "packing";
		$condition = array('id'=>$id);
		$this->mastermodel->delete_current_data($tableName,$condition);
		redirect('master/listpacking');
	}
	/*********************  END packing  *****************************************/
	
    public function addsetting($id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "setting";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
			if(!empty($id))
			{
				$data['title'] = "Edit Setting";
				$condition = array('id'=>$id);
				$data['setting_name'] = $this->mastermodel->edit_current_data($tableName,$condition);
				$this->load->view('master/addsetting', $data);
			}
    }
	
	public function insert_setting($id=NULL) // Insert data Into Database
	{	
			$tableName = "setting";
			$max_qty=$this->input->post('max_qty');
			if(!empty($id))
			{
				$update_data = array(
				'max_qty' => $max_qty
				);
				$condition = array('id'=>$id);
				$data_exist = $this->mastermodel->update_current_data($tableName,$condition,$update_data);
			}
			else
			{
				$insert_data = array(
				'max_qty' => $max_qty
				);
				$data_exist = $this->mastermodel->add_current_data($tableName,$insert_data);
			}
				redirect('master/addsetting/'.$id);
		}
	

		
}  //Close Master Class 
?>
