<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Category extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		$this->load->model('adminmodel');
		$this->load->model('mastermodel');
		$this->load->model('categorymodel');
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$type = $this->uri->segment(3);
		$get_url_id = $this->adminmodel->user_form_authentication($url,$type);
	}	

	/************************************* START category ************************************/
	
	public function listcategory() //View List With Dynamic Pagination
	{
		$this-> form_authentication();
		$tableName = "category";
		$orderBy = "name";
		$data['title'] = "List Category";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$data['category_name']=$this->categorymodel->view_all_data($tableName,$orderBy);  
 

       	$this->load->view('category/listcategory', $data);
	}	

    public function addcategory($type,$id=NULL) // Open Add form  and Edit 
    {	
		$this-> form_authentication();
		$tableName = "category";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
			if(!empty($id))
			{
				$data['title'] = "Edit Category";
				$condition = array('id'=>$id);
				$data['category_name'] = $this->categorymodel->edit_current_data($tableName,$condition);
				$this->load->view('category/addcategory', $data);
			}
			else
			{
				$data['title'] = "Add Category";
				$this->load->view('category/addcategory', $data);
			}
    }
	
	public function insert_category($id=NULL) // Insert data Into Database
	{	
	
		if(isset($_FILES['userfile']['name']))
		{
				$config['upload_path']          = '.././category_image/';
                $config['allowed_types']        = 'pdf|PDF|doc|docx|jpg|JPG|jpeg|png|JPEG';
				$config['remove_spaces'] = TRUE;
				$new_name =$_FILES["userfile"]['name'];
				$config['file_name'] = $new_name;
				
                $this->load->library('upload', $config);
                if(!$this->upload->do_upload('userfile'))
                {
                        $error = array('error' => $this->upload->display_errors());
						$file_name = "";
                       //$this->load->view('employment/addemployment', $error);
					 //  print_r($error);
                }
                else
                {
                        $data = $this->upload->data();
						$file_name = "category_image/".$data['file_name'];
                        //$this->load->view('upload_success', $data);
                }
				//echo $file_name;
				
				
		}	
	
			$tableName = "category";
			$name=$this->input->post('name');
			if(!empty($id))
			{
				if($file_name!='')
					{
					$update_data = array(
					'name' => $name,
					'image' => $file_name
					);
					}
				else
					{
					$update_data = array(
					'name' => $name
					);
					}
				$condition = array('id'=>$id);
				$data_exist = $this->categorymodel->update_current_data($tableName,$condition,$update_data);
				redirect('category/submitted/2');
			}
			else
			{
				$insert_data = array(
				'name' => $name,
				'image' => $file_name
				);
				$data_exist = $this->categorymodel->add_current_data($tableName,$insert_data);
			}
			if($data_exist)
			{
			  $this->session->set_flashdata('duplicate_message',$country.' Already Exist');
				redirect('category/addcategory/'.$id);
			}
			else
			{
				redirect('category/submitted/1');
			}
		}
	public function delete_category($id)  // Delete From Database
	{
		$tableName = "category";
		$condition = array('id'=>$id);
		$this->categorymodel->delete_current_data($tableName,$condition);
		redirect('category/listcategory/4');
	}
	/*********************  END category  *****************************************/
	
		public function submitted($id)
	{	
		if($id ==1)
		{
			$data['submit_msg'] = "Your Category Inserted Successfully";
		}elseif($id ==2)
		{
			$data['submit_msg'] = "Your Category Updated Successfully";
		}
		
		
		$data['title'] = "Form Submitted";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$this->load->view('form_submit',$data);
	}
			
	
		
}  //Close category Class 
?>
