<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Banner extends CI_Controller{

    public function __construct()
    {
        parent::__construct();
        $this->logged_in();
		$this->load->library('pagination');
		
		$this->load->model('adminmodel');
		$this->load->model('bannermodel');
		
		//$this->form_authentication();
    }
    private function logged_in() {
        if(! $this->session->userdata('authenticated')) {
            redirect('admin/login');
        }
    }
	
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$type = $this->uri->segment(3);
		$get_url_id = $this->adminmodel->user_form_authentication($url,$type);
	}	

	/************************************* START COUNTRY ********************************************************/
	
	public function formsubmit($id) //View List With Dynamic Pagination
	{
	    $this-> form_authentication();
		$data = array();
		$data['title']="Thanks";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		
		if($id == '1')
		{
		  $data['msz'] = "<font color='#000000'>Banner is added Successfully...</font>";
		}
		elseif($id == '2')
		{
		  $data['msz'] = "<font color='#000000'>Banner is edited Successfully...</font>";
		}
		
			
        $limit_per_page = 2;
        $page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
        $total_records = $this->bannermodel->get_total_banner();
		
     	$data['limit_per_page'] =  $limit_per_page;
		$data['page'] =  $page;
		$data['total_records'] =  $total_records;

	     $this->load->view('formsubmitted', $data);
			
			  
	}	
	
	
	public function listbanner($type) //View List With Dynamic Pagination
	{
	    $this-> form_authentication();
		$data = array();
		$data['title']="List Banner";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
			
        $limit_per_page = 25;
        $page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
        $total_records = $this->bannermodel->get_total_banner();
		
     	$data['limit_per_page'] =  $limit_per_page;
		$data['page'] =  $page;
		$data['total_records'] =  $total_records;
    	    if($total_records > 0)
			{
				// get current page records
				$data["bannerdata"] = $this->bannermodel->view_banner_data($limit_per_page, $page*$limit_per_page);
				
				//$data["departmentid11"] =  $this->mastermodel->get_department_id();
				
				$config['base_url'] = base_url() . 'banner/listbanner'.'/'.$type;
				$config['total_rows'] = $total_records;
				$config['per_page'] = $limit_per_page;
				$config["uri_segment"] = 4;
				// custom paging configuration
				$config['num_links'] = 2;
				$config['use_page_numbers'] = TRUE;
				$config['reuse_query_string'] = TRUE;
				$config['full_tag_open'] = '<div class="pagination">';
				$config['full_tag_close'] = '</div>';
				$config['first_link'] = 'First Page';
				$config['first_tag_open'] = '<span class="firstlink">';
				$config['first_tag_close'] = '</span>';
				$config['last_link'] = 'Last Page';
				$config['last_tag_open'] = '<span class="lastlink">';
				$config['last_tag_close'] = '</span>';
				$config['next_link'] = 'Next Page';
				$config['next_tag_open'] = '<span class="nextlink">';
				$config['next_tag_close'] = '</span>';
				$config['prev_link'] = 'Prev Page';
				$config['prev_tag_open'] = '<span class="prevlink">';
				$config['prev_tag_close'] = '</span>';
				$config['cur_tag_open'] = '<span class="curlink">';
				$config['cur_tag_close'] = '</span>';
				$config['num_tag_open'] = '<span class="numlink">';
				$config['num_tag_close'] = '</span>';
				 
				$this->pagination->initialize($config);
				// build paging links
				$data["links"] = $this->pagination->create_links();
			}
		
			  $this->load->view('banner/listbanner', $data);
	}	
	
    public function addbanner($type,$id=NULL) // Open Add form  and Edit 
    {	
	    $this-> form_authentication();
		$data['main_url']=$this->adminmodel->left_main_menu();
		$data['sub_url']=$this->adminmodel->left_sub_menu();
		//$data["hsndata"] = $this->categorymodel->view_hsn_data();
		
				
		if(!empty($id))
		{
			$data['title']="Edit Banner";
			$data['bannerdata']=$this->bannermodel->edit_banner_data($id);
			
			$this->load->view('banner/addbanner',$data);
		}
		else
		{
			$data['title']="Add Banner";
			$this->load->view('banner/addbanner',$data);
		}
	}
	
	public function insert_banner($id=NULL)  // Insert data Into Database
	{
		$tableName = "banner";
		$max = "id";
		$banner_image=$this->input->post('banner_image');
		$banner_link=$this->input->post('banner_link');
		$active=$this->input->post('active');
		$sort_order=$this->input->post('sort_order');
		
		$admin_id=$this->session->userdata('admin_id');
		$current_date=date('Y-m-d H:i:s');
		$admin_ip=$_SERVER['REMOTE_ADDR'];
		
			if(!empty($id))
			{
				if(!empty($_FILES['userfile']['name']) && isset($_FILES['userfile']['name']) )
				{	
					$condition = array('id'=>$id);
					$image_exist = $this->bannermodel->image_exist($tableName,$condition);
					foreach ($image_exist as $key) {
						if(file_exists('../'.$key->image))
						{
							unlink('../'.$key->image);
						}
					}
					$config['upload_path']          = '../banner_image/';
				    $config['allowed_types']        = 'png|jpg';
					$config['remove_spaces'] = TRUE;
					$config['overwrite']     = TRUE;
					$new_name = $id.'_'.$_FILES["userfile"]['name'];
					$config['file_name'] = $new_name;
				    $this->load->library('upload', $config);
				    if(!$this->upload->do_upload('userfile'))
				    {
				    	$filename ="";
						$filename_thumb ="";
				    }
					else
				    {
				    $data = $this->upload->data();
					$filename = "banner_image/".$new_name;
					
					$file_ext = $data['file_ext'];
					$orig_name = $data['orig_name'];
					$orig_name_new = substr_replace($orig_name ,"", -4);
					$filename_thumb = "banner_image/thumb/".$orig_name_new."_thumb".$file_ext;
					$this->resizeImage($data['file_path'],$data['file_name']);
				    }
				}
				
				
				$admin_ip=$_SERVER['REMOTE_ADDR'];
					if(!empty($filename))
					{
					$update_data = array(
					'banner_link'=>$banner_link,
					'active'=>$active,
					'sort_order'=>$sort_order,
					'banner_image' => $filename,
					'modified_by'=>$admin_id,
					'modified_datetime'=>$current_date,
					'modified_ip'=>$admin_ip

					);
					}else
					{
					$update_data = array(
					'banner_link'=>$banner_link,
					'active'=>$active,
					'sort_order'=>$sort_order,
					'modified_by'=>$admin_id,
					'modified_datetime'=>$current_date,
					'modified_ip'=>$admin_ip
					);

				}
				$condition = array('id'=>$id);
				$data_exist = $this->bannermodel->update_banner_data($tableName,$condition,$update_data);
				//$data_exist=$this->categorymodel->update_category_data($category_data,$id,$category_code);
		
				redirect('banner/submitted/2');
			}
			else
			{	
				if(!empty($_FILES['userfile']['name']))
				{	echo "abc";
					$max_id = $this->bannermodel->get_max_id($tableName,$max);
					$config['upload_path']          = '../banner_image/';
				    $config['allowed_types']        = 'png|jpg|';
					$config['remove_spaces'] = TRUE;
					$config['overwrite']     = TRUE;
					$new_name = $max_id.'_'.$_FILES["userfile"]['name'];
					$config['file_name'] = $new_name;
				    $this->load->library('upload', $config);
				    $this->upload->do_upload('userfile');
				    $data = $this->upload->data();
					$filename = "banner_image/".$new_name;
					
					$file_ext = $data['file_ext'];
					$orig_name = $data['orig_name'];
					$orig_name_new = substr_replace($orig_name ,"", -4);
					$filename_thumb = "banner_image/thumb/".$orig_name_new."_thumb".$file_ext;
					$this->resizeImage($data['file_path'],$data['file_name']);
					
					
				$insert_data = array(
					'banner_link'=>$banner_link,
					'active'=>$active,
					'sort_order'=>$sort_order,
					'banner_image' => $filename,
					'created_by'=>$admin_id,
					'created_datetime'=>$current_date,
					'created_ip'=>$admin_ip,
					'modified_datetime'=>'0000-00-00 00:00:00',
		
				);
				}	
				$insert_data = array(
					'banner_link'=>$banner_link,
					'active'=>$active,
					'sort_order'=>$sort_order,
					'banner_image' => $filename,
					'created_by'=>$admin_id,
					'created_datetime'=>$current_date,
					'created_ip'=>$admin_ip,
					'modified_datetime'=>'0000-00-00 00:00:00',
		
				);
				$data_exist = $this->bannermodel->add_banner_data($tableName,$insert_data);
			}

		redirect('banner/submitted/1');
		
				
	}
	
	public function delete_banner($id) // Delete From Database
	{
	
		$condition = array('id'=>$id);
		$image_exist = $this->bannermodel->image_exist('banner',$condition);
		foreach ($image_exist as $key) {
		if(file_exists('../'.$key->image))
		{
		unlink('../'.$key->image);
		}
	  }
	
		$this->bannermodel->delete_banner_data($id);
		redirect('banner/listbanner/4');
	}
	
	
public function resizeImage($file_path,$file_name)
{
      $source_path =$file_path . $file_name;
      $target_path =$file_path . "thumb/" . $file_name;
      $config_manip = array(
         'image_library' => 'gd2',
          'source_image' => $source_path,
          'new_image' => $target_path,
          'maintain_ratio' => TRUE,
          'create_thumb' => TRUE,
          'thumb_marker' => '_thumb',
          'width' => 400,
          'height' => 400
      );
      $this->load->library('image_lib', $config_manip);
      if (!$this->image_lib->resize()) {
          echo $this->image_lib->display_errors();
      }
      $this->image_lib->clear();
}

	
		public function submitted($id)
	{	
		if($id ==1)
		{
			$data['submit_msg'] = "Your Banner Inserted Successfully";
		}elseif($id ==2)
		{
			$data['submit_msg'] = "Your Banner Updated Successfully";
		}
		
		
		$data['title'] = "Form Submitted";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		$this->load->view('form_submit',$data);
	}
	
}  //Close Master Class 
?>
