<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Admin  extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form','url');
        $this->load->library('form_validation');
        $this->load->model('adminmodel');
		//$this->load->library(array('globals'));
		
    }
	
    private function logged_in()
    {
        if( ! $this->session->userdata('authenticated')){
     		redirect('admin/login');
        }
		
    }
	
	/*public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$get_url_id = $this->adminmodel->user_form_authentication($url);
	}	*/
	
	public function form_authentication()
	{
		$url= $this->uri->segment(1)."/".$this->uri->segment(2);
		$get_url_id = $this->adminmodel->user_master_form_authentication($url);
		//echo $url;
		//exit();
	}	
	
	public function index()
	{
		redirect('admin/login');
	}
    
    public function login()
    {
		  if($this->session->userdata('authenticated')) 
		  {
            redirect('admin/dashboard');
          }
				
        $data['title'] = "Login";
        
        $this->form_validation->set_rules('username', 'Username', 'trim|required');
        $this->form_validation->set_rules('password', 'Password', 'required');
        
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        if($this->form_validation->run() == false){
            $this->load->view('login', $data);
        } 
        else {
            $username = $this->security->xss_clean($this->input->post('username'));
            $password = $this->security->xss_clean($this->input->post('password'));
            
            $user = $this->adminmodel->login($username, $password);
            
            if($user){
                $userdata = array(
                    'admin_id' => $user->admin_id,
					'uid' => $user->uid,
					'pwd' => $user->pwd,
                    'name' => $user->name,
                    'authenticated' => TRUE
                );
                
                $this->session->set_userdata($userdata);
				redirect('admin/dashboard');

            }
            else {
                $this->session->set_flashdata('message', 'Invalid Username or Password');
                redirect('admin/login');
            }
        }
    }

	public function dashboard()
	{
		$this->logged_in();
		$data['title'] = "Dashboard";
		$data['main_url'] =$this->adminmodel->left_main_menu();
		$data['sub_url'] =$this->adminmodel->left_sub_menu();
		//print_r($data['main_url']);
		//exit();
		$this->load->view('index', $data);
	}
	public function logout()
    {
        $this->session->sess_destroy();
        redirect('admin/login');
    }
	
	/******************** change password *****************************/
	
	 public function changepassword($id=NULL) // Open Add form  and Edit 
    {	
			$this->logged_in();
			$this->form_authentication();
			$data['main_url'] =$this->adminmodel->left_main_menu();
			$data['sub_url'] =$this->adminmodel->left_sub_menu();
			$data['title'] = "Change Password";
			$this->load->view('changepassword', $data);
    }
	
	public function insert_change_password() // Insert data Into Database
	{		
				$this->logged_in();
				$this->form_authentication();
				$old_password=$this->input->post('old_pwd');
				$pwd=$this->input->post('new_pwd');
				$password_data = array(
				'pwd'=>$pwd
				);
				$this->adminmodel->update_change_password($old_password,$password_data);
				redirect('admin/dashboard');
	}
	/***************** change password *************************/
	
	/*************************************Start  Form Authentication***********************/
	public function selectuser($id =NULL)
	{
			if($id=='1')
			{
			$data['success_msg'] = "Authnetication Successful";
			}
			
			$this->logged_in();
			$this->form_authentication();
			$data['title'] = "Select User";
			$data['user_name'] = $this->adminmodel->select_user();
 			$data['main_url'] =$this->adminmodel->left_main_menu();
			$data['sub_url'] =$this->adminmodel->left_sub_menu();
			
			$this->load->view('selectuser',$data);
	}
	
	public function formauthentication($admin_id = NULL)
	{
			$this->logged_in();
			$this->form_authentication();
			$data['title'] = "Form Authentication";

			$selected_user = $this->input->post('admin_id');
			$admin_id1 = explode('~',$selected_user);
			$data['admin_id'] = $admin_id1['0'];
			$data['admin_name'] = $admin_id1['1'];
			$admin_id = $admin_id1['0'];
			
			$data['athenticated_form'] = $this->adminmodel->get_athenticated_form($admin_id);
			$data['main_url'] =$this->adminmodel->left_main_menu();
			$data['sub_url'] =$this->adminmodel->left_sub_menu();
			$this->load->view('formauthentication',$data);
	}
	
	
	public function insert_forms_id()
	{
			$this->logged_in();
			$this->form_authentication();
			$admin_id = $this->input->post('admin_id');
			$admin_name = $this->input->post('admin_name');
			$form_id = $this->input->post('form_id[]');
			
			$this->adminmodel->delete_form_id($admin_id);
			$array_length = sizeof($form_id);
			for($i=0;$i<$array_length;$i++)
			{
			if(!empty($form_id) )
					{ 
						$form_data = array(
						'admin_id' => $admin_id,
						'form_id' =>$form_id[$i]
						);
			}
			$this->adminmodel->insert_form_id($form_data);
			}
			redirect('admin/selectuser');
	}
	/*******************END  Form Authentication************************/
  	
  	public function error_404()
  	{	
  		$data['title'] = "Error 404";
  		$this->load->view('error_404');
  	}
	

} //Admin Class Close

?>
